<?php 
/** 
 * ------------------------------------------------------------------------
 * JA Builder Component
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2018 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */


defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;
/**
 * Articles list controller class.
 *
 * @since  1.6
 */
class JabuilderControllerRevisions extends JControllerAdmin
{

	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  The array of possible config values. Optional.
	 *
	 * @return  JModelLegacy
	 *
	 * @since   1.6
	 */
	function display ($cachable = false, $urlparams = false)
	{
		$this->input->set('view', 'revisions');
		parent::display();
	}

	public function getModel($name = 'revisions', $prefix = 'JabuilderModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}
	public function delRevision(){

		$this->checkToken();

		// Get items to remove from the request.
		$cid = $this->input->get('cid', array(), 'array');
		// Get items to remove from the request.
		$page_id = $this->input->getInt('id');
		if (!is_array($cid) || count($cid) < 1)
		{
			JError::raiseWarning(500, JText::_('COM_JABUILDER_NO_ITEM_REVISION_SELECTED'));
		}
		else
		{
			// Get the model.
			$model = $this->getModel();

			// Make sure the item ids are integers
			$cid = ArrayHelper::toInteger($cid);

			//check if has one revision
			if($cid[0] == $model->subQuery($page_id)){
				$this->setMessage(JText::_('Do not delete the last revision'));
			}else{
				// Remove the items.
				if ($model->delete($cid,$page_id))
				{
					$this->setMessage(JText::plural('COM_JABUILDER_N_ITEMS_REVISION_DELETED', count($cid)));
				}
				else
				{
					$this->setMessage($model->getError());
				}
			}
			
		}

		$this->setRedirect(
			JRoute::_(
				'index.php?option=com_jabuilder&view=revisions&tmpl=component&id='. $this->input->getInt('id') , false
			)
		);

	}
	public function removeAllRev() {
		// Get items to remove from the request.
		$page_id = $this->input->getInt('id');
		// Get the model.
		$model = $this->getModel();

		// Remove the items.
		if ($model->deleteAll($page_id))
		{
			$this->setMessage(JText::_('COM_JABUILDER_ALL_ITEMS_REVISION_DELETED'));
		}
		else
		{
			$this->setMessage($model->getError());
		}
		
		$this->setRedirect(
			JRoute::_(
				'index.php?option=com_jabuilder&view=revisions&tmpl=component&id='. $this->input->getInt('id') , false
			)
		);
	}
}
?>