<?php

/**
 * ------------------------------------------------------------------------
 * JA Builder Component
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2018 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */
class JabuilderModelRevisions extends JModelList
{
    /**
     * summary
     */
    public function __construct($config = array())
    {
        parent::__construct($config);
    }
    public function getRevisions () {
    	$input = JFactory::getApplication()->input;
    	$id = $input->getInt('id');
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	$query->select ("*")
    		->from($db->quotename('#__jabuilder_revisions'))
    		->where('itemid = ' . $db->quote($id))
    		->order('id DESC');
		$db->setQuery($query);
		return $db->loadObjectList();
    }
    public function delete($cid,$page_id){

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->delete('#__jabuilder_revisions')
			->where($db->quotename('id') . " IN (" . implode(',', $cid) . ")")
			->where($db->quotename('id') . " NOT IN ( " . $this->subQuery($page_id).")");
		$db->setQuery($query);
		return $db->execute();

    }
    public function deleteAll($page_id)
    {
    	$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->delete('#__jabuilder_revisions')
			->where($db->quotename('itemid') . " = " . $db->quote($page_id))
			->where($db->quotename('id') . " NOT IN ( " . $this->subQuery($page_id).")");

		$db->setQuery($query);
		return $db->execute();
    }
    public function subQuery($page_id)
    {
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	$query->select("MAX(id) as id")
    			->from('#__jabuilder_revisions')
    			->where($db->quotename('itemid') . " = " . $db->quote($page_id));
    	$result = $db->setQuery($query)->loadResult();

		return $db->setQuery($query)->loadResult();
    }
}


?>
