<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>JA Builder Editor</title>
	<link rel="stylesheet" href="<?php echo JUri::root(true)?>/media/editors/codemirror/lib/codemirror.css" />
	<link rel="stylesheet" href="<?php echo JUri::root(true)?>/media/editors/codemirror/theme/monokai.css" />
	<link rel="stylesheet" href="<?php echo JUri::root(true)?>/media/editors/codemirror/addon/hint/show-hint.css" />
	<link rel="stylesheet" href="<?php echo JUri::root(true)?>/media/jui/css/icomoon.css" />
	<link rel="stylesheet" href="<?php echo JUri::root(true)?>/plugins/system/jabuilder/assets/css/jabuilder.css" />
	<script src="<?php echo JUri::root(true)?>/media/jui/js/jquery.min.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/jui/js/jquery-noconflict.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/jui/js/jquery-migrate.min.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/editors/codemirror/lib/codemirror.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/plugins/system/jabuilder/assets/js/formatting.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/editors/codemirror/mode/css/css.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/editors/codemirror/mode/xml/xml.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/editors/codemirror/mode/htmlmixed/htmlmixed.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/editors/codemirror/addon/hint/show-hint.js" type="text/javascript"></script>
	<script src="<?php echo JUri::root(true)?>/media/editors/codemirror/addon/hint/css-hint.js" type="text/javascript"></script>

</head>
<body class="jub-page-edit">
<?php 
	$top = $bottom = $header = $footer = false;
	$content_flag = true;
	$tabEdit = array('top','bottom','header','footer');
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$url = str_replace('jub=editContent','preview=1',str_replace('jub=editContent','preview=1',$actual_link));
	$url .= '&'. JSession::getFormToken() .'=1';
	$returnUrl = str_replace('?jub=editContent','',str_replace('&jub=editContent','',$actual_link));
	$helper = $displayData['helper'];
	$data = $displayData['data'];
	if($data->type != 'page'){
		$dataEdit = json_decode($data->content,true);
		$content_flag = false;
		foreach ($tabEdit as $tab) {
			if(!empty($dataEdit[$tab])){
				switch ($tab) {
					case 'top':
						$top = true;
						break;
					case 'bottom':
						$bottom = true;
						break;
					case 'header':
						$header = true;
						break;
					case 'footer':
						$footer = true;
						break;
					default:
						
						break;
				}
			}
		}
	}
	$preview = $helper->app->input->get('preview','');
	if($helper->app->input->get('update','') && !$preview){
		if($data->type == 'page'){
			$data->content = $_POST['content'];
		}else{
			foreach ($tabEdit as $tab) {
				if(!empty($_POST[$tab])) $dataEdit[$tab] = $_POST[$tab];
			}
			$data->content = json_encode($dataEdit);
		}
		$helper->customSaveItem($data);
	}else {
		if($preview){
			if($data->type == 'page'){
				$data->content = $_POST['content'];
			}else{
				foreach ($tabEdit as $tab) {
					if(!empty($_POST[$tab])) $dataEdit[$tab] = $_POST[$tab];
				}
				$data->content = json_encode($dataEdit);
			}
		}
		//save for prewiew
		$helper->savePreview($data);
	}
?>
<div class="jub-edit-header">
	<h3>JA Builder - Content Edit</h3>
	<div class="ja-builder-action">
		<button type="button btn-preview" class="btn btn-preview"><span class="icon-eye-open"></span>Preview</button>
		<button class="btn btn-save" type="submit" onclick="jaSubmit();" /><span class="icon-publish"></span>Save</button>
		<button type="button btn-cancel" class="btn btn-cancel" onclick="jareturn();"><span class="icon-cancel-2"></span>Cancel</button>
	</div>
</div>

<div class="jub-editor">
	<form action="" method="POST" class="ja-builder-form">
		<div class="content-edit">
			<?php if($top): ?>
			<div><label for="">Top Content</label></div>
			<textarea id="ja-builder-top" name="top"><?php echo $dataEdit['top']; ?></textarea>
			<?php endif; ?>
			<?php if($bottom): ?>
			<div><label for="">bottom Content</label></div>
			<textarea id="ja-builder-bottom" name="bottom"><?php echo $dataEdit['bottom']; ?></textarea>
			<?php endif; ?>
			<?php if($header): ?>
			<div><label for="">header Content</label></div>
			<textarea id="ja-builder-header" name="header"><?php echo $dataEdit['header']; ?></textarea>
			<?php endif; ?>
			<?php if($footer): ?>
				<div><label for="">footer Content</label></div>
			<textarea id="ja-builder-footer" name="footer"><?php echo $dataEdit['footer']; ?></textarea>
			<?php endif; ?>
			<?php if($content_flag): ?>
				<textarea id="ja-builder-content" name="content"><?php echo $data->content; ?></textarea>
			<?php endif; ?>
		</div>
		<input type="hidden" name="id" value="<?php echo $data->id; ?>" />
	</form>
</div>


<!-- Preview page -->
<div class="jab-builder-preview" style="display: none;">
	<div class="iframe-preview">
		<div class="preview-header">
			<h3>Page Preview</h3>
			<button class="btn btn-close" type="button" title="Close">&times;</button>
		</div>

		<iframe class="ja-iframe" src="<?php echo $url;?>"></iframe>

	</div>
</div>
<!-- // Preview page -->

<script>
  let topCode, bottomCode, headerCode, footerCode,contentCode;

	

	function getSelectedRange(code) {
		code.execCommand('selectAll');
    return { from: code.getCursor(true), to: code.getCursor(false) };
  }
	var initCodeMirror = function(type,cls){
		if(jQuery(cls).length){
			type = CodeMirror.fromTextArea(jQuery(cls).get(0),{
					lineNumbers: true,
					mode: "htmlmixed",
					autofocus: true,
					tabsize: 2,
					direction: (document.dir == 'rtl')  ? "rtl" : "ltr",
					firstLineNumber: 1
				});
			setTimeout(function(){
				var range = getSelectedRange(type);
		    type.autoFormatRange(range.from, range.to);
		    type.focus();
		    type.setCursor(0, 0);
		  }, 1);
		}
		return type;
	}
	contentCode = initCodeMirror("contentCode",'#ja-builder-content');
	topCode = initCodeMirror("topCode",'#ja-builder-top');
	bottomCode = initCodeMirror("bottomCode",'#ja-builder-bottom');
	headerCode = initCodeMirror("headerCode",'#ja-builder-header');
	footerCode = initCodeMirror("footerCode",'#ja-builder-footer');
	var getCode = function(type){
		return type.getDoc().getValue("\n");
	}
	var jareturn = function(){
		var returnUrl = '<?php echo $returnUrl;?>';
		location.href = returnUrl;
		return false;
	}
	var jaSubmit = function(){
		var url = '<?php echo $actual_link."&update=1";?>';
  	var data = <?php echo json_encode($data);?>;
  	var top = "<?php echo $top; ?>";
  	var bottom = "<?php echo $bottom; ?>";
  	var header = "<?php echo $header; ?>";
  	var footer = "<?php echo $footer; ?>";
  	let dataSub = {};
		if(data.type == 'page'){
			let content = getCode(contentCode);
			dataSub.content = content;
		}else{
			if(top){
				let top = getCode(topCode);
				dataSub.top = top;
			}
			if(bottom){
				let bottom = getCode(bottomCode);
				dataSub.bottom = bottom;
			}
			if(header){
				let header = getCode(headerCode);
				dataSub.header = header;
			}
			if(footer){
				let footer = getCode(footerCode);
				dataSub.footer = footer;
			}
		}
		jQuery.post(url,dataSub).done(function( data ) {
			var url = '<?php echo $actual_link;?>';
			url = url.replace(/(\?|\&)jub=editContent/,"");
			location.href = url;
	  });
	}
  jQuery(document).ready(function($){
  	var url = '<?php echo $actual_link."&preview=1";?>';
  	var data = <?php echo json_encode($data);?>;
  	var top = "<?php echo $top; ?>";
  	var bottom = "<?php echo $bottom; ?>";
  	var header = "<?php echo $header; ?>";
  	var footer = "<?php echo $footer; ?>";
  	$('.btn-preview').on('click',function(){
  	 	let dataSub = {};
  		if(data.type == 'page'){
  			let content = getCode(contentCode);
  			dataSub.content = content;
  		}else{
  			if(top){
  				let top = getCode(topCode);
  				dataSub.top = top;
  			}
  			if(bottom){
  				let bottom = getCode(bottomCode);
  				dataSub.bottom = bottom;
  			}
  			if(header){
  				let header = getCode(headerCode);
  				dataSub.header = header;
  			}
  			if(footer){
  				let footer = getCode(footerCode);
  				dataSub.footer = footer;
  			}
  		}
  		$.post(url,dataSub).done(function( data ) {
  			$('.jab-builder-preview').find('.ja-iframe').attr( 'src', function ( i, val ) { return val; });
  			$('body').addClass('modal-open');
  			$('body').append('<div class="ja-builder-backdrop"></div>');
		    $('.jab-builder-preview').fadeIn();
		  });
  	});
  	$('.btn-close').on('click',function(e) {
  		$('body').removeClass('modal-open');
  		$('body').find('.ja-builder-backdrop').remove();
  		$('.jab-builder-preview').fadeOut();
  	})
  });
</script>
</body>
</html>